#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include <Array.au3>

#include "GUITFLabel.au3"

$iGUI_Width = @DesktopWidth - 200
$iGUI_Height = 600

$hGUI = GUICreate("StringCompare Example", $iGUI_Width, $iGUI_Height)

$sString1 = "This is a test1, test of _StringCompare function. But needs more testing"
$sString2 = "This is a quest, qest of _StringCompare functiom. But needs more testing"

;~ $sString1 = _
;~ 	'       16  2011 . N 4226 "       "'

;~ $sString2 = _
;~ 	'       16  2011 . N 4226 "         "'

$aCompare = _StringCompare($sString1, $sString2, 0)

;~ _ArrayDisplay($aCompare)
;~ Exit

Dim $aColors[5] = ['green', 'red', 'purple', 'pink', 'blue']
$iClr_Cnt = 0

For $i = UBound($aCompare)-1 To 1 Step -1
	$sFontStr1 = '<font color="white" bkcolor="' & $aColors[$iClr_Cnt] & '">' & $aCompare[$i][2] & '</font>'
	$sFontStr2 = '<font color="white" bkcolor="' & $aColors[$iClr_Cnt] & '">' & $aCompare[$i][3] & '</font>'
	
	$sString1 = _
		StringLeft($sString1, $aCompare[$i][0]) & _
		$sFontStr1 & _
		StringMid($sString1, $aCompare[$i][0] + StringLen($aCompare[$i][2]) + 1)
	
	$sString2 = _
		StringLeft($sString2, $aCompare[$i][1]) & _
		$sFontStr2 & _
		StringMid($sString2, $aCompare[$i][1] + StringLen($aCompare[$i][3]) + 1)
	
	$iClr_Cnt += 1
	If $iClr_Cnt > 4 Then $iClr_Cnt = 0
Next

$nLabel1 = _GUICtrlTFLabel_Create($sString1, 20, 20, $iGUI_Width - 40, ($iGUI_Height / 2) - 5)
_GUICtrlCreateSeparator(2, ($iGUI_Height / 2) - 2, $iGUI_Width - 4, 4)
$nLabel2 = _GUICtrlTFLabel_Create($sString2, 20, ($iGUI_Height / 2) + 5, $iGUI_Width - 40, ($iGUI_Height / 2) - 5)

GUISetState(@SW_SHOW, $hGUI)

While 1
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE
			Exit
	EndSwitch
WEnd

Func _StringCompare($sString1, $sString2, $iMode = 0)
	Local $aRet, $iLen1, $iLen2, $iBiggestLen, $i, $sChar1, $sChar2, $s_Char1, $s_Char2, $iPos1, $iPos2, $i_Pos1, $i_Pos2, $iCnt
	
	;This mode is for the getting changes for each word seperately, but need major tweaking work...
	If $iMode = 1 Then
		$iLen1 = StringLen($sString1)
		$iLen2 = StringLen($sString2)
		
		$iBiggestLen = $iLen1
		If $iLen2 > $iLen1 Then $iBiggestLen = $iLen2
		
		Dim $aRet[$iBiggestLen+1][4] = [[0]]
		
		For $i = 1 To $iLen1
			$sChar1 = StringMid($sString1, $i, 1)
			
			If StringRegExp($sChar1, '([--߸\w]+)') Then
				$iPos1 = $i
				$sChar = $sChar1
				
				For $j = $i + 1 To $iLen1 - 1
					$sChar = StringMid($sString1, $j, 1)
					
					If $sChar = "" Or Not StringRegExp($sChar, '([--߸\w]+)') Then ExitLoop
					
					$sChar1 &= $sChar
				Next
				
				$i = $j
				
				$aRet[0][0] += 1
				$aRet[$aRet[0][0]][0] = $iPos1 - 1
				$aRet[$aRet[0][0]][2] = $sChar1
			EndIf
		Next
		
		For $i = 1 To $iLen2
			$sChar2 = StringMid($sString2, $i, 1)
			
			If StringRegExp($sChar2, '([--߸\w]+)') Then
				$iPos2 = $i
				$sChar = $sChar2
				
				For $j = $i + 1 To $iLen2 - 1
					$sChar = StringMid($sString2, $j, 1)
					
					If $sChar = "" Or Not StringRegExp($sChar, '([--߸\w]+)') Then ExitLoop
					
					$sChar2 &= $sChar
				Next
				
				$i = $j
				$iCnt += 1
				
				$aRet[$iCnt][1] = $iPos2 - 1
				$aRet[$iCnt][3] = $sChar2
			EndIf
		Next
		
		Dim $a_Ret[$aRet[0][0]+1][4] = [[0]]
		
		For $i = 1 To $aRet[0][0]
			$iFound = 0
			
			For $j = 1 To $aRet[0][0]
				If $j = $i Then ContinueLoop
				
				If $aRet[$i][2] = $aRet[$j][3] Then
					$iFound = 1
					ExitLoop
				EndIf
			Next
			
			If $aRet[$i][2] <> $aRet[$i][3] Then
				$a_Ret[0][0] += 1
				$a_Ret[$a_Ret[0][0]][0] = $aRet[$i][0]
				$a_Ret[$a_Ret[0][0]][1] = $aRet[$i][1]
				$a_Ret[$a_Ret[0][0]][2] = $aRet[$i][2]
				$a_Ret[$a_Ret[0][0]][3] = $aRet[$i][3]
			EndIf
		Next
		
		$aRet = $a_Ret
		
		ReDim $aRet[$aRet[0][0]+1][4]
		Return $aRet
	EndIf
	
	$iLen1 = StringLen($sString1)
	$iLen2 = StringLen($sString2)
	
	$iBiggestLen = $iLen1
	If $iLen2 > $iLen1 Then $iBiggestLen = $iLen2
	
	Dim $aRet[$iBiggestLen+1][4] = [[0]]
	
	For $i = 1 To $iBiggestLen
		$sChar1 = StringMid($sString1, $i, 1)
		$sChar2 = StringMid($sString2, $i, 1)
		
		If $sChar1 <> $sChar2 Then
			$s_Char1 = $sChar1
			$s_Char2 = $sChar2
			
			$iPos1 = $i
			$iPos2 = $i
			
			While $s_Char1 <> $s_Char2
				$i += 1
				
				$s_Char1 = StringMid($sString1, $i, 1)
				$s_Char2 = StringMid($sString2, $i, 1)
				
				If $s_Char1 <> $s_Char2 Then
					$sChar1 &= $s_Char1
					$sChar2 &= $s_Char2
				EndIf
			WEnd
			
			$aRet[0][0] += 1
			$aRet[$aRet[0][0]][0] = $iPos1 - 1
			$aRet[$aRet[0][0]][1] = $iPos2 - 1
			$aRet[$aRet[0][0]][2] = $sChar1
			$aRet[$aRet[0][0]][3] = $sChar2
		EndIf
	Next
	
	ReDim $aRet[$aRet[0][0]+1][4]
	Return $aRet
EndFunc

Func _GUICtrlCreateSeparator($iLeft, $iTop, $iLenght, $iWidth = -1, $nStyle = $SS_ETCHEDHORZ)
	Local $nSetStyle = $nStyle, $iTmpSwap
	
	If $iWidth > 0 Then
		$nSetStyle = $SS_SUNKEN
	EndIf
	
	Switch $nStyle
		Case $SS_ETCHEDHORZ
			$iTmpSwap = $iWidth
			$iWidth = $iLenght
			$iLenght = $iTmpSwap
		Case $SS_ETCHEDVERT
			If $nSetStyle <> $SS_SUNKEN Then
				$iWidth = -1
			EndIf
		Case Else
			If $nSetStyle <> $SS_SUNKEN Then
				Return SetError(1, 0, 0)
			EndIf
	EndSwitch
	
	If $iLenght = -1 Then
		$iLenght = 1
	EndIf
	
	If $iWidth = -1 Then
		$iWidth = 1
	EndIf
	
	Return GUICtrlCreateLabel("", $iLeft, $iTop, $iWidth, $iLenght, $nSetStyle)
EndFunc
